/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftp;

import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftp.CoFilenameFilter;
import com.quantumdata.ftp.CoOrder;
import com.quantumdata.std.IQDConsole;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public final class LocalFile
extends File
implements CoFile {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private String ext = null;
    private String descr = "";

    private void sortSetup(String string) {
        this.name = string.toUpperCase();
        int n = this.name.lastIndexOf(".");
        this.ext = n != -1 && n < this.name.length() ? this.name.substring(n) : " " + this.name;
    }

    public int compareNameToIgnoreCase(CoOrder coOrder) {
        if (coOrder instanceof LocalFile) {
            LocalFile localFile = (LocalFile)coOrder;
            return this.name.compareTo(localFile.name);
        }
        throw new ClassCastException();
    }

    public int compareExtToIgnoreCase(CoOrder coOrder) {
        if (coOrder instanceof LocalFile) {
            LocalFile localFile = (LocalFile)coOrder;
            int n = this.ext.compareTo(localFile.ext);
            if (n == 0) {
                n = this.name.compareTo(localFile.name);
            }
            return n;
        }
        throw new ClassCastException();
    }

    public boolean startsWithIgnoreCase(char c) {
        return this.name.charAt(0) == Character.toUpperCase(c);
    }

    public boolean equalsExtTo(String string) {
        return this.ext.compareTo(string) == 0;
    }

    public boolean equalsExtTo(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.ext.compareTo(stringArray[i]) != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.compareToObj(object) == 0;
    }

    public int compareToObj(Object object) {
        String string;
        String string2 = this.getHost() + this.getAbsolutePath();
        if (object instanceof CoFile) {
            CoFile coFile = (CoFile)object;
            string = coFile.getHost() + coFile.getAbsolutePath();
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            throw new ClassCastException();
        }
        return string2.compareTo(string);
    }

    public boolean isConnected() {
        return true;
    }

    public char getDataType() {
        return 'I';
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this);
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this);
    }

    public OutputStream getOutputStream(boolean bl) throws IOException {
        return new FileOutputStream(this.toString(), bl);
    }

    public CoFile newFileChild(String string) {
        return new LocalFile(this, string);
    }

    public CoFile newFileRename(String string) {
        return new LocalFile(this.getParent(), string);
    }

    public IQDConsole getConsole() {
        return null;
    }

    public LocalFile(String string) {
        super(string);
        this.sortSetup(this.getName());
    }

    public LocalFile(String string, String string2) {
        super(string, string2);
        this.sortSetup(string2);
    }

    public LocalFile(LocalFile localFile, String string) {
        super(localFile, string);
        this.sortSetup(string);
    }

    public String getHost() {
        return "";
    }

    public int getPathDepth() {
        String string = this.getAbsolutePath();
        int n = -1;
        int n2 = -1;
        while ((n2 = string.indexOf(separatorChar, n2 + 1)) >= 0) {
            ++n;
        }
        if (!string.endsWith(separator)) {
            ++n;
        }
        return n;
    }

    public CoFile getPathFragment(int n) {
        String string = this.getAbsolutePath();
        if (n > 0) {
            int n2 = -1;
            for (int i = 0; i <= n && (n2 = string.indexOf(separatorChar, n2 + 1)) >= 0; ++i) {
            }
            if (n2 > 0) {
                return new LocalFile(string.substring(0, n2));
            }
            return this;
        }
        return new LocalFile(string.substring(0, string.indexOf(separatorChar) + 1));
    }

    public String[] getPathArray() {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        String string = this.getAbsolutePath();
        if (string != null) {
            objectArray = new StringTokenizer(string, separator);
            try {
                while (true) {
                    String string2 = objectArray.nextToken();
                    vector.addElement(string2);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getName() {
        return super.getName();
    }

    public String getParent() {
        return super.getParent();
    }

    public boolean delete() throws SecurityException {
        return super.delete();
    }

    public boolean mkdir() throws SecurityException {
        return super.mkdir();
    }

    public boolean mkdirs() throws SecurityException {
        return super.mkdirs();
    }

    public boolean renameTo(CoFile coFile) throws SecurityException {
        return super.renameTo((File)((Object)coFile));
    }

    public String lastModifiedString() {
        return DateFormat.getDateTimeInstance(3, 3).format(new Date(this.lastModified()));
    }

    public long length() {
        return super.length();
    }

    public long lastModified() {
        return super.lastModified();
    }

    public boolean isAbsolute() {
        return super.isAbsolute();
    }

    public boolean isDirectory() {
        return super.isDirectory();
    }

    public boolean isFile() {
        return super.isFile();
    }

    public boolean isSpecial() {
        return false;
    }

    public boolean isLink() {
        return false;
    }

    public boolean canRead() {
        return super.canRead();
    }

    public boolean canWrite() {
        return super.canWrite();
    }

    public boolean exists() {
        return super.exists();
    }

    public String getAccess() {
        String string = null;
        string = this.isDirectory() ? "d" : "-";
        string = this.canRead() ? string + "r" : string + "-";
        string = this.canWrite() ? string + "w?" : string + "-?";
        return string;
    }

    public String propertyString() {
        return (this.isFile() ? "" + this.length() + " " : "") + this.getAccess();
    }

    public CoFile[] listCoRoots() {
        File[] fileArray = LocalFile.listRoots();
        if (fileArray == null) {
            return null;
        }
        CoFile[] coFileArray = new LocalFile[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            coFileArray[i] = new LocalFile(fileArray[i].getAbsolutePath());
        }
        return coFileArray;
    }

    public CoFile[] listCoFiles() throws SecurityException {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        CoFile[] coFileArray = new LocalFile[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            coFileArray[i] = new LocalFile(this.getAbsolutePath(), stringArray[i]);
        }
        return coFileArray;
    }

    public CoFile[] listCoFiles(CoFilenameFilter coFilenameFilter) throws SecurityException {
        Object[] objectArray = (LocalFile[])this.listCoFiles();
        if (objectArray == null) {
            return null;
        }
        if (coFilenameFilter != null) {
            Vector<Object> vector = new Vector<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!coFilenameFilter.accept(this, ((LocalFile)objectArray[i]).getName())) continue;
                vector.addElement(objectArray[i]);
            }
            objectArray = new LocalFile[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    public void setDescription(String string) {
        this.descr = string;
    }

    public String getDescription() {
        return this.descr;
    }
}

